/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.LinkedList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ReverseThePolarityCounterAllEffect
extends OneShotEffect {
    ReverseThePolarityCounterAllEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter all other spells.";
    }

    private ReverseThePolarityCounterAllEffect(ReverseThePolarityCounterAllEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        LinkedList<Spell> spellsToCounter = new LinkedList<Spell>();
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.getId().equals(source.getSourceObject(game).getId())) continue;
            spellsToCounter.add((Spell)stackObject);
        }
        for (Spell spell : spellsToCounter) {
            game.getStack().counter(spell.getId(), source, game);
        }
        return true;
    }

    public ReverseThePolarityCounterAllEffect copy() {
        return new ReverseThePolarityCounterAllEffect(this);
    }
}

