/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RevivalRevengeEffect
extends OneShotEffect {
    RevivalRevengeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Double your life total. Target opponent loses half their life, rounded up.";
    }

    private RevivalRevengeEffect(RevivalRevengeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevivalRevengeEffect copy() {
        return new RevivalRevengeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        controller.gainLife(controller.getLife(), game, source);
        int life = player.getLife();
        player.loseLife(Math.floorDiv(life, 2) + life % 2, game, source, false);
        return true;
    }
}

