/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.r.RevivifyEffect;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.watchers.Watcher;
import mage.watchers.common.CardsPutIntoGraveyardWatcher;

public final class Revivify
extends CardImpl {
    static final FilterCard filter = new FilterCreatureCard();
    private static final DynamicValue xValue;
    private static final Hint hint;

    public Revivify(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{W}");
        RollDieWithResultTableEffect effect = new RollDieWithResultTableEffect(20, "roll a d20 and add the number of creature cards in your graveyard that were put there from the battlefield this turn", xValue, 0);
        this.getSpellAbility().addEffect((Effect)effect);
        this.getSpellAbility().addWatcher((Watcher)new CardsPutIntoGraveyardWatcher());
        this.getSpellAbility().addHint(hint);
        effect.addTableEntry(1, 14, new Effect[]{new RevivifyEffect(true)});
        effect.addTableEntry(15, Integer.MAX_VALUE, new Effect[]{new RevivifyEffect(false)});
    }

    private Revivify(Revivify card) {
        super((CardImpl)card);
    }

    public Revivify copy() {
        return new Revivify(this);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
        xValue = new CardsInControllerGraveyardCount(filter);
        hint = new ValueHint("Creature cards in your graveyard that died this turn", xValue);
    }
}

