/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.r.Revivify;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RevivifyEffect
extends OneShotEffect {
    private final boolean toHand;

    RevivifyEffect(boolean toHand) {
        super(Outcome.Benefit);
        this.toHand = toHand;
        this.staticText = toHand ? "return all creature cards in your graveyard that were put there from the battlefield this turn to your hand" : "return those cards from your graveyard to the battlefield";
    }

    private RevivifyEffect(RevivifyEffect effect) {
        super((OneShotEffect)effect);
        this.toHand = effect.toHand;
    }

    public RevivifyEffect copy() {
        return new RevivifyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(player.getGraveyard().getCards(Revivify.filter, source.getControllerId(), source, game), this.toHand ? Zone.HAND : Zone.BATTLEFIELD, source, game);
    }
}

