/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class RevokePrivilegeCantCrewEffect
extends ContinuousRuleModifyingEffectImpl {
    RevokePrivilegeCantCrewEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", or crew Vehicles";
    }

    private RevokePrivilegeCantCrewEffect(RevokePrivilegeCantCrewEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RevokePrivilegeCantCrewEffect copy() {
        return new RevokePrivilegeCantCrewEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "The creature enchanted by " + mageObject.getIdName() + " can't crew vehicles.";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREW_VEHICLE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && event.getTargetId().equals(enchantment.getAttachedTo());
    }
}

