/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RexCyberhoundContinuousEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard();

    RexCyberhoundContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all cards in exile with brain counters on them";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private RexCyberhoundContinuousEffect(RexCyberhoundContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public RexCyberhoundContinuousEffect copy() {
        return new RexCyberhoundContinuousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return false;
        }
        for (Card card : game.getExile().getCardsInRange(filter, source.getControllerId(), source, game)) {
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isActivatedAbility()) continue;
                ActivatedAbility copyAbility = (ActivatedAbility)ability.copy();
                perm.addAbility((Ability)copyAbility, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterType.BRAIN.getPredicate());
    }
}

