/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RhetTombMysticEffect
extends ContinuousEffectImpl {
    RhetTombMysticEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each creature card in your hand has cycling {1}{U}";
    }

    private RhetTombMysticEffect(RhetTombMysticEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getHand().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).forEach(card -> game.getState().addOtherAbility(card, (Ability)new CyclingAbility((Cost)new ManaCostsImpl("{1}{U}"))));
        return true;
    }

    public ContinuousEffect copy() {
        return new RhetTombMysticEffect(this);
    }
}

