/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class RhinosRampageEffect
extends OneShotEffect {
    RhinosRampageEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "When excess damage is dealt to the creature an opponent controls this way, destroy up to one target noncreature artifact with mana value 3 or less";
    }

    protected RhinosRampageEffect(RhinosRampageEffect effect) {
        super((OneShotEffect)effect);
    }

    public RhinosRampageEffect copy() {
        return new RhinosRampageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(((Target)source.getTargets().get(1)).getFirstTarget());
        if (permanent == null || permanent.getDamage() <= permanent.getToughness().getBaseValue()) {
            return false;
        }
        FilterArtifactPermanent filter = new FilterArtifactPermanent("noncreature artifact with mana value 3 or less");
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 3));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false);
        ability.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

