/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.r.RhukHexgoldNabberEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.EquippedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class RhukHexgoldNabberTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    RhukHexgoldNabberTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RhukHexgoldNabberEffect(), true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private RhukHexgoldNabberTriggeredAbility(RhukHexgoldNabberTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RhukHexgoldNabberTriggeredAbility copy() {
        return new RhukHexgoldNabberTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE || event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent2;
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (!zEvent.isDiesEvent()) {
                    return false;
                }
                permanent2 = zEvent.getTarget();
                break;
            }
            case ATTACKER_DECLARED: {
                Permanent permanent2 = game.getPermanent(event.getSourceId());
            }
            default: {
                return false;
            }
        }
        if (permanent2 == null || !filter.match(permanent2, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setValue("equippedPermanent", (Object)permanent2);
        return true;
    }

    public String getRule() {
        return "Whenever an equipped creature you control other than {this} attacks or dies, you may attach all Equipment attached to that creature to {this}.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
        }
        return super.isInUseableZone(game, sourceObject, event);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)EquippedPredicate.instance);
    }
}

