/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RidersOfGavonyGainAbilityControlledEffect
extends ContinuousEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("Human creatures you control");
    protected FilterPermanent protectionFilter;

    public RidersOfGavonyGainAbilityControlledEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Human creatures you control have protection from creatures of the chosen type";
    }

    private RidersOfGavonyGainAbilityControlledEffect(RidersOfGavonyGainAbilityControlledEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.protectionFilter = effect.protectionFilter;
    }

    public RidersOfGavonyGainAbilityControlledEffect copy() {
        return new RidersOfGavonyGainAbilityControlledEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        if (this.protectionFilter == null && (permanent = game.getPermanent(source.getSourceId())) != null) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)permanent.getId(), (Game)game);
            if (subType != null) {
                this.protectionFilter = new FilterPermanent(subType.getDescription() + 's');
                this.protectionFilter.add((Predicate)subType.getPredicate());
            } else {
                this.discard();
            }
        }
        if (this.protectionFilter != null) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                perm.addAbility((Ability)new ProtectionAbility((Filter)this.protectionFilter), source.getSourceId(), game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.HUMAN.getPredicate());
    }
}

