/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.r.RipSpawnHunterTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RipSpawnHunterEffect
extends OneShotEffect {
    RipSpawnHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top X cards of your library, where X is its power. Put any number of creature and/or Vehicle cards with different powers from among them into your hand. Put the rest on the bottom of your library in a random order";
    }

    private RipSpawnHunterEffect(RipSpawnHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public RipSpawnHunterEffect copy() {
        return new RipSpawnHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int power = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(MageObject::getPower).map(MageInt::getValue).orElse(0);
        if (player == null || power < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, power));
        if (cards.isEmpty()) {
            return false;
        }
        player.revealCards(source, (Cards)cards, game);
        RipSpawnHunterTarget target = new RipSpawnHunterTarget();
        player.choose(Outcome.ReturnToHand, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

