/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.GoblinSoldierToken;
import mage.players.Player;

class RiseOfTheHobgoblinsEffect
extends OneShotEffect {
    RiseOfTheHobgoblinsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may pay {X}. If you do, create X 1/1 red and white Goblin Soldier creature tokens";
    }

    private RiseOfTheHobgoblinsEffect(RiseOfTheHobgoblinsEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiseOfTheHobgoblinsEffect copy() {
        return new RiseOfTheHobgoblinsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (you != null && you.chooseUse(Outcome.Neutral, "Do you want to to pay {X}?", source, game)) {
            int costX = you.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to add counters)", game, source, true);
            cost.add((Object)new GenericManaCost(costX));
            if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                GoblinSoldierToken token = new GoblinSoldierToken();
                return token.putOntoBattlefield(costX, game, source, source.getControllerId());
            }
        }
        return false;
    }
}

