/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RisenExecutionerCastEffect
extends AsThoughEffectImpl {
    protected static final FilterCreatureCard filter = new FilterCreatureCard();

    RisenExecutionerCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard if you pay {1} more to cast it for each other creature card in your graveyard";
    }

    private RisenExecutionerCastEffect(RisenExecutionerCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public RisenExecutionerCastEffect copy() {
        return new RisenExecutionerCastEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!sourceId.equals(source.getSourceId())) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null || !card.isOwnedBy(affectedControllerId) || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int costIncrease = controller.getGraveyard().count((FilterCard)filter, source.getControllerId(), source, game);
        ManaCosts adjustedCost = CardUtil.adjustCost((ManaCosts)card.getSpellAbility().getManaCostsToPay(), (int)(-costIncrease));
        controller.setCastSourceIdWithAlternateMana(card.getId(), adjustedCost, null, MageIdentifier.RisenExectutionerAlternateCast);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

