/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RiskFactorEffect
extends OneShotEffect {
    RiskFactorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent may have {this} deal 4 damage to them. If that player doesn't, you draw three cards.";
    }

    private RiskFactorEffect(RiskFactorEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiskFactorEffect copy() {
        return new RiskFactorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        if (opponent.chooseUse(this.outcome, "Do you choose to take the damage?", source, game)) {
            opponent.damage(4, source.getSourceId(), source, game);
        } else {
            controller.drawCards(3, source, game);
        }
        return true;
    }
}

