/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RiskyMoveGetControlEffect
extends OneShotEffect {
    RiskyMoveGetControlEffect() {
        super(Outcome.GainControl);
        this.staticText = "that player gains control of {this}";
    }

    private RiskyMoveGetControlEffect(RiskyMoveGetControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiskyMoveGetControlEffect copy() {
        return new RiskyMoveGetControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player newController = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (newController != null && controller != null && sourceObject != null && sourceObject.equals(sourcePermanent)) {
            for (ContinuousEffect effect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
                if (!(effect instanceof GainControlTargetEffect)) continue;
                UUID checkId = (UUID)effect.getValue("RiskyMoveSourceId");
                UUID controllerId = (UUID)effect.getValue("RiskyMoveControllerId");
                if (!source.getSourceId().equals(checkId) || !newController.getId().equals(controllerId)) continue;
                effect.discard();
            }
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, true, newController.getId());
            effect.setValue("RiskyMoveSourceId", (Object)source.getSourceId());
            effect.setValue("RiskyMoveControllerId", (Object)newController.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent.getId(), game));
            effect.setText("and gains control of it");
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

