/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RiteOfConsumptionEffect
extends OneShotEffect {
    RiteOfConsumptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage equal to the sacrificed creature's power to target player or planeswalker. You gain life equal to the damage dealt this way";
    }

    private RiteOfConsumptionEffect(RiteOfConsumptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiteOfConsumptionEffect copy() {
        return new RiteOfConsumptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sacrificedCreature = null;
            for (Cost cost : source.getCosts()) {
                Permanent permanent;
                SacrificeTargetCost sacCost;
                Iterator iterator;
                if (!(cost instanceof SacrificeTargetCost) || !(iterator = (sacCost = (SacrificeTargetCost)cost).getPermanents().iterator()).hasNext()) continue;
                sacrificedCreature = permanent = (Permanent)iterator.next();
            }
            if (sacrificedCreature != null) {
                int damageDealt;
                int damage = sacrificedCreature.getPower().getValue();
                if (damage > 0 && (damageDealt = game.damagePlayerOrPermanent(source.getFirstTarget(), damage, source.getSourceId(), source, game, false, true)) > 0) {
                    controller.gainLife(damage, game, source);
                }
                return true;
            }
        }
        return false;
    }
}

