/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class RiteOfHarmonyTriggeredAbility
extends DelayedTriggeredAbility {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("creature or enchantment");

    RiteOfHarmonyTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false);
    }

    private RiteOfHarmonyTriggeredAbility(RiteOfHarmonyTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        Permanent permanent = game.getPermanent(targetId);
        return filter.match(permanent, this.getControllerId(), (Ability)this, game);
    }

    public RiteOfHarmonyTriggeredAbility copy() {
        return new RiteOfHarmonyTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature or enchantment you control enters this turn, draw a card.";
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

