/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class RitesOfSpringEffect
extends OneShotEffect {
    RitesOfSpringEffect() {
        super(Outcome.DrawCard);
        this.staticText = "discard any number of cards. Search your library for up to that many basic land cards, reveal them, put them into your hand, then shuffle";
    }

    private RitesOfSpringEffect(RitesOfSpringEffect effect) {
        super((OneShotEffect)effect);
    }

    public RitesOfSpringEffect copy() {
        return new RitesOfSpringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numDiscarded = controller.discard(0, Integer.MAX_VALUE, false, source, game).size();
        if (numDiscarded == 0) {
            return true;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(numDiscarded, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        controller.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        controller.getLibrary().getCards(game).stream().filter(Objects::nonNull).map(MageItem::getId).filter(target.getTargets()::contains).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        controller.revealCards(source, (Cards)cards, game);
        controller.moveCards((Cards)cards, Zone.HAND, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

