/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class RithLiberatedPrimevalWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    RithLiberatedPrimevalWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && ((DamagedEvent)event).getExcess() > 0) {
            this.playerSet.addAll(game.getOpponents(game.getControllerId(event.getTargetId())));
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((RithLiberatedPrimevalWatcher)game.getState().getWatcher(RithLiberatedPrimevalWatcher.class)).playerSet.contains(playerId);
    }
}

