/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class RitualOfSubdualReplacementEffect
extends ReplacementEffectImpl {
    RitualOfSubdualReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a land is tapped for mana, it produces colorless mana instead of any other type.";
    }

    private RitualOfSubdualReplacementEffect(RitualOfSubdualReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RitualOfSubdualReplacementEffect copy() {
        return new RitualOfSubdualReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.ColorlessMana((int)mana.count()));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game);
    }
}

