/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.RitualOfTheReturnedZombieToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class RitualOfTheReturnedExileEffect
extends OneShotEffect {
    RitualOfTheReturnedExileEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature card from your graveyard. Create a black Zombie creature token. Its power is equal to that card's power and its toughness is equal to that card's toughness.";
    }

    private RitualOfTheReturnedExileEffect(RitualOfTheReturnedExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public RitualOfTheReturnedExileEffect copy() {
        return new RitualOfTheReturnedExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getCard(this.getTargetPointer().getFirst(game, source))) != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
            controller.moveCardToExileWithInfo(card, null, null, source, game, Zone.GRAVEYARD, true);
            return new CreateTokenEffect((Token)new RitualOfTheReturnedZombieToken(card.getPower().getValue(), card.getToughness().getValue())).apply(game, source);
        }
        return false;
    }
}

