/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileGraveyardAllTargetPlayerEffect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.MaxManaValueControlledCreatureOrPlaneswalkerPredicate;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetOpponent;

public final class RiveteersCharm
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker they control with the highest mana value among creatures and planeswalkers they control");

    public RiveteersCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{B}{R}{G}");
        this.getSpellAbility().addEffect((Effect)new SacrificeEffect(filter, 1, "target opponent"));
        this.getSpellAbility().addTarget((Target)new TargetOpponent());
        this.getSpellAbility().addMode(new Mode((Effect)new ExileTopXMayPlayUntilEffect(3, Duration.UntilYourNextEndStep)));
        this.getSpellAbility().addMode(new Mode((Effect)new ExileGraveyardAllTargetPlayerEffect()).addTarget((Target)new TargetPlayer()));
    }

    private RiveteersCharm(RiveteersCharm card) {
        super((CardImpl)card);
    }

    public RiveteersCharm copy() {
        return new RiveteersCharm(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)MaxManaValueControlledCreatureOrPlaneswalkerPredicate.instance);
    }
}

