/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class RoarOfTheCrowdEffect
extends OneShotEffect {
    RoarOfTheCrowdEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Choose a creature type. {this} deals damage to any target equal to the number of permanents you control of the chosen type.";
    }

    private RoarOfTheCrowdEffect(RoarOfTheCrowdEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoarOfTheCrowdEffect copy() {
        return new RoarOfTheCrowdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            if (!player.choose(Outcome.LoseLife, (Choice)typeChoice, game)) {
                return false;
            }
            FilterControlledPermanent filter = new FilterControlledPermanent();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            return new DamageTargetEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)filter)).apply(game, source);
        }
        return false;
    }
}

