/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SagaAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.permanent.token.DinosaurVanillaToken;
import mage.game.permanent.token.Token;
import mage.target.common.TargetCardInLibrary;

public final class RoarOfTheFifthPeople
extends CardImpl {
    private static final FilterCard filterCard = new FilterCard("Dinosaur card");
    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.DINOSAUR, "Dinosaurs you control");

    public RoarOfTheFifthPeople(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "");
        this.color.setWhite(true);
        this.color.setGreen(true);
        this.color.setRed(true);
        this.subtype.add((Object)SubType.SAGA);
        this.nightCard = true;
        SagaAbility sagaAbility = new SagaAbility((Card)this, SagaChapter.CHAPTER_IV);
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_I, new Effect[]{new CreateTokenEffect((Token)new DinosaurVanillaToken(), 2)});
        SimpleStaticAbility gainedAbility = new SimpleStaticAbility((Effect)new GainAbilityControlledEffect((Ability)new RedManaAbility(), Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, false).setText("Creatures you control have '{T}: Add {R}"));
        gainedAbility.addEffect((Effect)new GainAbilityControlledEffect((Ability)new GreenManaAbility(), Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, false).setText(", {G}"));
        gainedAbility.addEffect((Effect)new GainAbilityControlledEffect((Ability)new WhiteManaAbility(), Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, false).setText(", or {W}.'"));
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_II, new Effect[]{new GainAbilitySourceEffect((Ability)gainedAbility, Duration.WhileOnBattlefield).setText("{this} gains \"Creatures you control have '{T}: Add {R}, {G}, or {W}.'\"")});
        TargetCardInLibrary target = new TargetCardInLibrary(filterCard);
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_III, new Effect[]{new SearchLibraryPutInHandEffect(target, true)});
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_IV, new Effect[]{new GainAbilityControlledEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter).setText("Dinosaurs you control gain double strike"), new GainAbilityControlledEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter).setText("and trample until end of turn")});
        this.addAbility((Ability)sagaAbility);
    }

    private RoarOfTheFifthPeople(RoarOfTheFifthPeople card) {
        super((CardImpl)card);
    }

    public RoarOfTheFifthPeople copy() {
        return new RoarOfTheFifthPeople(this);
    }

    static {
        filterCard.add((Predicate)SubType.DINOSAUR.getPredicate());
    }
}

