/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalAsThoughEffect;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.abilities.effects.common.asthought.YouMaySpendManaAsAnyColorToCastTargetEffect;
import mage.cards.Card;
import mage.cards.r.RogueAttackedThisTurnCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RobberOfTheRichEffect
extends OneShotEffect {
    RobberOfTheRichEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of their library. During any turn you attacked with a Rogue, you may cast that card and you may spend mana as though it were mana of any color to cast that spell";
    }

    private RobberOfTheRichEffect(RobberOfTheRichEffect effect) {
        super((OneShotEffect)effect);
    }

    public RobberOfTheRichEffect copy() {
        return new RobberOfTheRichEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || damagedPlayer == null) {
            return false;
        }
        Card card = damagedPlayer.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        if (card.getSpellAbility() != null) {
            Ability copiedAbility = source.copy();
            copiedAbility.newId();
            copiedAbility.setSourceId(card.getId());
            copiedAbility.setControllerId(source.getControllerId());
            PlayFromNotOwnHandZoneTargetEffect playFromExile = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfGame);
            YouMaySpendManaAsAnyColorToCastTargetEffect spendAnyMana = new YouMaySpendManaAsAnyColorToCastTargetEffect(Duration.EndOfGame);
            ConditionalAsThoughEffect castOnlyIfARogueAttackedThisTurn = new ConditionalAsThoughEffect((AsThoughEffect)playFromExile, (Condition)new RogueAttackedThisTurnCondition(copiedAbility));
            playFromExile.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            spendAnyMana.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            castOnlyIfARogueAttackedThisTurn.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)castOnlyIfARogueAttackedThisTurn, copiedAbility);
            game.addEffect((ContinuousEffect)spendAnyMana, copiedAbility);
            return true;
        }
        return false;
    }
}

