/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.r.RodOfAbsorptionExileEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class RodOfAbsorptionTriggeredAbility
extends TriggeredAbilityImpl {
    RodOfAbsorptionTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private RodOfAbsorptionTriggeredAbility(RodOfAbsorptionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RodOfAbsorptionTriggeredAbility copy() {
        return new RodOfAbsorptionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new RodOfAbsorptionExileEffect(spell, game));
        return true;
    }

    public String getRule() {
        return "Whenever a player casts an instant or sorcery spell, exile it instead of putting it into a graveyard as it resolves.";
    }
}

