/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class RonaSheoldredsFaithfulEffect
extends AsThoughEffectImpl {
    RonaSheoldredsFaithfulEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "you may cast {this} from your graveyard by discarding two cards in addition to paying its other costs";
    }

    private RonaSheoldredsFaithfulEffect(RonaSheoldredsFaithfulEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public RonaSheoldredsFaithfulEffect copy() {
        return new RonaSheoldredsFaithfulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.getSourceId().equals(objectId) || !source.isControlledBy(affectedControllerId) || game.getState().getZone(objectId) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectedControllerId);
        if (controller == null) {
            return false;
        }
        CostsImpl costs = new CostsImpl();
        costs.add((Object)new DiscardTargetCost(new TargetCardInHand(2, StaticFilters.FILTER_CARD_CARDS)));
        controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{1}{U}{B}{B}"), (Costs)costs, MageIdentifier.RonaSheoldredsFaithfulAlternateCast);
        return true;
    }
}

