/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RonaTolarianObliteratorEffect
extends OneShotEffect {
    RonaTolarianObliteratorEffect() {
        super(Outcome.Benefit);
    }

    private RonaTolarianObliteratorEffect(RonaTolarianObliteratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public RonaTolarianObliteratorEffect copy() {
        return new RonaTolarianObliteratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        Card card = player.getHand().getRandom(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (!card.isLand(game)) {
            return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
        }
        return controller.chooseUse(Outcome.PutLandInPlay, "Put " + card.getIdName() + " onto the battlefield?", source, game) && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

