/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class RooftopStormRuleEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("Zombie creature spells");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new ManaCostsImpl("{0}"), (Condition)SourceIsSpellCondition.instance, null, filter, true);

    public RooftopStormRuleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You may pay {0} rather than pay the mana cost for Zombie creature spells you cast";
    }

    private RooftopStormRuleEffect(RooftopStormRuleEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public RooftopStormRuleEffect copy() {
        return new RooftopStormRuleEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }

    static {
        filter.add((Predicate)SubType.ZOMBIE.getPredicate());
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

