/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeXTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class RottenmouthViperCostReductionEffect
extends CostModificationEffectImpl {
    RottenmouthViperCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
    }

    private RottenmouthViperCostReductionEffect(RottenmouthViperCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public RottenmouthViperCostReductionEffect copy() {
        return new RottenmouthViperCostReductionEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        int reduction = 0;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof SacrificeXTargetCost)) continue;
            if (game.inCheckPlayableState()) {
                reduction += ((SacrificeXTargetCost)cost).getMaxValue((Ability)spellAbility, game);
                break;
            }
            reduction += ((SacrificeXTargetCost)cost).getAmount();
            break;
        }
        CardUtil.adjustCost((SpellAbility)spellAbility, (int)reduction);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }
}

