/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ParleyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class RousingOfSoulsEffect
extends OneShotEffect {
    RousingOfSoulsEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Parley</i> &mdash; Each player reveals the top card of their library. For each nonland card revealed this way, you create a 1/1 white Spirit creature token with flying";
    }

    private RousingOfSoulsEffect(RousingOfSoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public RousingOfSoulsEffect copy() {
        return new RousingOfSoulsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int parley = ParleyCount.getInstance().calculate(game, source, (Effect)this);
            if (parley > 0) {
                new CreateTokenEffect((Token)new SpiritWhiteToken(), parley).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

