/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.ControllerLostLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class RowanScionOfWarEffect
extends CostModificationEffectImpl {
    RowanScionOfWarEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast this turn that are black and/or red cost {X} less to cast, where X is the amount of life you lost this turn.";
    }

    private RowanScionOfWarEffect(RowanScionOfWarEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, ControllerLostLifeCount.instance.calculate(game, source, (Effect)this)));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        SpellAbility spell = (SpellAbility)abilityToModify;
        ObjectColor color = spell.getCharacteristics(game).getColor(game);
        return spell.isControlledBy(source.getControllerId()) && game.getCard(spell.getSourceId()) != null && (color.isRed() || color.isBlack());
    }

    public RowanScionOfWarEffect copy() {
        return new RowanScionOfWarEffect(this);
    }
}

