/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RowenAbility
extends TriggeredAbilityImpl {
    private int lastTriggeredTurn;

    RowenAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InfoEffect(""), false);
    }

    private RowenAbility(RowenAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RowenAbility copy() {
        return new RowenAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId()) && game.isActivePlayer(this.getControllerId()) && this.lastTriggeredTurn != game.getTurnNum()) {
            Card card = game.getCard(event.getTargetId());
            Player controller = game.getPlayer(this.getControllerId());
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
            if (card != null && controller != null && sourcePermanent != null) {
                this.lastTriggeredTurn = game.getTurnNum();
                controller.revealCards(sourcePermanent.getName(), (Cards)new CardsImpl(card), game);
                this.getEffects().clear();
                if (card.isLand(game) && card.isBasic(game)) {
                    this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Reveal the first card you draw each turn. Whenever you reveal a basic land card this way, draw a card.";
    }
}

