/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class RuinInTheirWakeEffect
extends OneShotEffect {
    private static final FilterLandPermanent filterWastes = new FilterLandPermanent();

    public RuinInTheirWakeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a basic land card and reveal it. You may put that card onto the battlefield tapped if you control a land named Wastes. Otherwise, put that card into your hand. Then shuffle";
    }

    private RuinInTheirWakeEffect(RuinInTheirWakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RuinInTheirWakeEffect copy() {
        return new RuinInTheirWakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card;
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            if (controller.searchLibrary(target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                boolean controlWastes;
                CardsImpl cardsToReveal = new CardsImpl(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
                boolean bl = controlWastes = game.getBattlefield().countAll((FilterPermanent)filterWastes, controller.getId(), game) > 0;
                if (controlWastes && controller.chooseUse(this.outcome, "Put " + card.getLogName() + " onto battlefield tapped?", source, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
                } else {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filterWastes.add((Predicate)new NamePredicate("Wastes"));
    }
}

