/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.GoblinToken;
import mage.players.Player;

class RulikMonsWarrenChiefEffect
extends OneShotEffect {
    RulikMonsWarrenChiefEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield tapped. If you didn't put a card onto the battlefield this way, create a 1/1 red Goblin creature token.";
    }

    private RulikMonsWarrenChiefEffect(RulikMonsWarrenChiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public RulikMonsWarrenChiefEffect copy() {
        return new RulikMonsWarrenChiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean landToPlay = false;
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.lookAtCards("Top card of your library", card, game);
            boolean bl = landToPlay = card.isLand(game) && controller.chooseUse(this.outcome, "Put " + card.getName() + " into play tapped?", source, game) && controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        if (!landToPlay) {
            new GoblinToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

