/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class RunedCrownEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Rune card");

    RunedCrownEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may search your library, hand, and/or graveyard for a Rune card and put it onto the battlefield attached to {this}. If you search your library this way, shuffle";
    }

    private RunedCrownEffect(RunedCrownEffect effect) {
        super((OneShotEffect)effect);
    }

    public RunedCrownEffect copy() {
        return new RunedCrownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInYourGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = null;
        Zone zone = null;
        if (controller.chooseUse(Outcome.Neutral, "Search your graveyard for a Rune card?", source, game)) {
            target = new TargetCardInYourGraveyard(filter);
            target.withNotTarget(true);
            if (controller.choose(Outcome.PutCardInPlay, (Cards)controller.getGraveyard(), (TargetCard)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                zone = Zone.GRAVEYARD;
            }
        }
        if (card == null && controller.chooseUse(Outcome.Neutral, "Search your hand for a Rune card?", source, game)) {
            target = new TargetCardInHand(filter);
            if (controller.choose(Outcome.PutCardInPlay, controller.getHand(), (TargetCard)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                zone = Zone.HAND;
            }
        }
        if (card == null) {
            target = new TargetCardInLibrary(filter);
            if (controller.searchLibrary((TargetCardInLibrary)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                zone = Zone.LIBRARY;
            }
            controller.shuffleLibrary(source, game);
        }
        if (card == null) {
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            game.getState().setValue("attachTo:" + card.getId(), (Object)permanent);
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        if (permanent != null) {
            return permanent.addAttachment(card.getId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.RUNE.getPredicate());
    }
}

