/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.DamagedByWatcher;

class RuneswordCantBeRegeneratedEffect
extends ContinuousRuleModifyingEffectImpl {
    private UUID targetCreatureId;

    public RuneswordCantBeRegeneratedEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, false, false);
        this.staticText = "If the creature deals damage to a creature this turn, the creature dealt damage can't be regenerated this turn";
    }

    private RuneswordCantBeRegeneratedEffect(RuneswordCantBeRegeneratedEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.targetCreatureId = effect.targetCreatureId;
    }

    public RuneswordCantBeRegeneratedEffect copy() {
        return new RuneswordCantBeRegeneratedEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetCreatureId = this.getTargetPointer().getFirst(game, source);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REGENERATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagedByWatcher watcher;
        if (this.targetCreatureId != null && (watcher = (DamagedByWatcher)game.getState().getWatcher(DamagedByWatcher.class, this.targetCreatureId)) != null) {
            return watcher.wasDamaged(event.getTargetId(), game);
        }
        return false;
    }
}

