/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RuneswordCreateTriggeredAbilityEffect
extends OneShotEffect {
    RuneswordCreateTriggeredAbilityEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "When that creature leaves the battlefield this turn, sacrifice {this}";
    }

    private RuneswordCreateTriggeredAbilityEffect(RuneswordCreateTriggeredAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Permanent targetObject = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourceObject != null && targetObject != null) {
            SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice " + sourceObject.getName());
            sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(sourceObject, game));
            LeavesBattlefieldTriggeredAbility triggerAbility = new LeavesBattlefieldTriggeredAbility((Effect)sacrificeEffect, false);
            triggerAbility.setRuleVisible(false);
            GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)triggerAbility, Duration.EndOfTurn);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(targetObject, game));
            game.addEffect((ContinuousEffect)continuousEffect, source);
            return true;
        }
        return false;
    }

    public RuneswordCreateTriggeredAbilityEffect copy() {
        return new RuneswordCreateTriggeredAbilityEffect(this);
    }
}

