/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;

class RunicArmasaurTriggeredAbility
extends TriggeredAbilityImpl {
    RunicArmasaurTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
        this.setTriggerPhrase("Whenever an opponent activates an ability of a creature or land that isn't a mana ability, ");
    }

    private RunicArmasaurTriggeredAbility(RunicArmasaurTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RunicArmasaurTriggeredAbility copy() {
        return new RunicArmasaurTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility != null && stackAbility.isNonManaActivatedAbility() && game.getOpponents(this.getControllerId()).contains(stackAbility.getControllerId()) && stackAbility.getSourcePermanentOrLKI(game) != null) {
            MageObject abilitySourceObject = stackAbility.getSourceObject(game);
            return abilitySourceObject != null && (abilitySourceObject.isLand(game) || abilitySourceObject.isCreature(game));
        }
        return false;
    }
}

