/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RunoStromkirkEffect
extends OneShotEffect {
    RunoStromkirkEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may reveal that card. If a creature card with mana value 6 or greater is revealed this way, transform {this}";
    }

    private RunoStromkirkEffect(RunoStromkirkEffect effect) {
        super((OneShotEffect)effect);
    }

    public RunoStromkirkEffect copy() {
        return new RunoStromkirkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards(null, card, game);
        if (!player.chooseUse(this.outcome, "Reveal " + card.getName() + '?', source, game)) {
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!card.isCreature(game) || card.getManaValue() < 6) {
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.transform(source, game);
        }
        return true;
    }
}

