/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class RuptureEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature without flying");

    public RuptureEffect() {
        super(Outcome.Damage);
        this.staticText = "Sacrifice a creature. {this} deals damage equal to that creature's power to each creature without flying and each player";
    }

    private RuptureEffect(RuptureEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            Permanent permanent;
            int power = 0;
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            if (player.choose(Outcome.Sacrifice, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                power = permanent.getPower().getValue();
                permanent.sacrifice(source, game);
            }
            if (power > 0) {
                new DamageEverythingEffect(power, (FilterPermanent)filter).apply(game, source);
            }
            return true;
        }
        return false;
    }

    public RuptureEffect copy() {
        return new RuptureEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

