/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RushOfDreadSacrificeEffect
extends OneShotEffect {
    RushOfDreadSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent sacrifices half the creatures they control, rounded up";
    }

    private RushOfDreadSacrificeEffect(RushOfDreadSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RushOfDreadSacrificeEffect copy() {
        return new RushOfDreadSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        int creatures = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, opponent.getId(), source, game);
        int toSac = Math.floorDiv(creatures, 2) + creatures % 2;
        return new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, toSac, "").setTargetPointer((TargetPointer)new FixedTarget(opponent.getId())).apply(game, source);
    }
}

