/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RushTheRoomEffect
extends OneShotEffect {
    RushTheRoomEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a Goblin or Orc, it also gains haste until end of turn";
    }

    private RushTheRoomEffect(RushTheRoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public RushTheRoomEffect copy() {
        return new RushTheRoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (permanent.hasSubtype(SubType.GOBLIN, game) || permanent.hasSubtype(SubType.ORC, game))) {
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            return true;
        }
        return false;
    }
}

