/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RuthlessTechnomancerEffect
extends OneShotEffect {
    RuthlessTechnomancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature you control. If you do, create a number of Treasure tokens equal to that creature's power";
    }

    private RuthlessTechnomancerEffect(RuthlessTechnomancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RuthlessTechnomancerEffect copy() {
        return new RuthlessTechnomancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int power = permanent.getPower().getValue();
        return power < 1 || new TreasureToken().putOntoBattlefield(power, game, source);
    }
}

