/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ValkmiraProtectorsShieldPreventionEffect
extends PreventionEffectImpl {
    ValkmiraProtectorsShieldPreventionEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a source an opponent controls would deal damage to you or a permanent you control, prevent 1 of that damage";
    }

    private ValkmiraProtectorsShieldPreventionEffect(ValkmiraProtectorsShieldPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                boolean isOpponent = game.getOpponents(game.getControllerId(event.getSourceId())).contains(source.getControllerId());
                return isOpponent && source.isControlledBy(event.getTargetId()) && super.applies(event, source, game);
            }
            case DAMAGE_PERMANENT: {
                boolean isOpponent = game.getOpponents(game.getControllerId(event.getSourceId())).contains(source.getControllerId());
                Permanent permanent = game.getPermanent(event.getTargetId());
                return isOpponent && permanent != null && permanent.isControlledBy(source.getControllerId()) && super.applies(event, source, game);
            }
        }
        return false;
    }

    public ValkmiraProtectorsShieldPreventionEffect copy() {
        return new ValkmiraProtectorsShieldPreventionEffect(this);
    }
}

