/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;

class CurryFavorEffect
extends OneShotEffect {
    CurryFavorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain X life and each opponent loses X life, where X is the number of Knights you control";
    }

    private CurryFavorEffect(CurryFavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurryFavorEffect copy() {
        return new CurryFavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().filter(permanent -> permanent != null && permanent.hasSubtype(SubType.KNIGHT, game)).mapToInt(p -> 1).sum();
        new GainLifeEffect(xValue).apply(game, source);
        new LoseLifeOpponentsEffect(xValue).apply(game, source);
        return true;
    }
}

