/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GainLifeEqualToToughnessEffect
extends OneShotEffect {
    GainLifeEqualToToughnessEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to its toughness.";
    }

    private GainLifeEqualToToughnessEffect(GainLifeEqualToToughnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null && (player = game.getPlayer(source.getControllerId())) != null) {
            player.gainLife(permanent.getToughness().getValue(), game, source);
        }
        return false;
    }

    public GainLifeEqualToToughnessEffect copy() {
        return new GainLifeEqualToToughnessEffect(this);
    }
}

