/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GreatestPowerPredicate
implements Predicate<Permanent> {
    GreatestPowerPredicate() {
    }

    public boolean apply(Permanent input, Game game) {
        int power = input.getPower().getValue();
        for (UUID playerId : game.getPlayerList()) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game)) {
                if (permanent.getPower().getValue() < power || permanent.equals(input)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Greatest Power";
    }
}

