/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MayTapOrUntapAttachedEffect
extends OneShotEffect {
    MayTapOrUntapAttachedEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may tap or untap equipped creature.";
    }

    private MayTapOrUntapAttachedEffect(MayTapOrUntapAttachedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment == null) {
            equipment = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (equipment != null && equipment.getAttachedTo() != null) {
            Permanent equipedCreature = game.getPermanent(equipment.getAttachedTo());
            Player player = game.getPlayer(source.getControllerId());
            if (equipedCreature != null && player != null) {
                if (equipedCreature.isTapped()) {
                    if (player.chooseUse(Outcome.Untap, "Untap equipped creature?", source, game)) {
                        equipedCreature.untap(game);
                    }
                } else if (player.chooseUse(Outcome.Tap, "Tap equipped creature?", source, game)) {
                    equipedCreature.tap(source, game);
                }
                return true;
            }
        }
        return false;
    }

    public MayTapOrUntapAttachedEffect copy() {
        return new MayTapOrUntapAttachedEffect(this);
    }
}

