/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;

class MoveAuraEffect
extends OneShotEffect {
    MoveAuraEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Attach target Aura attached to a permanent to another permanent with the same controller.";
    }

    private MoveAuraEffect(MoveAuraEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoveAuraEffect copy() {
        return new MoveAuraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent aura = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || aura == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("permanent" + Optional.of(aura).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getControllerId(arg_0)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getName).map(s -> " controlled by" + s).orElse(""));
        filter.add((Predicate)new ControllerIdPredicate(game.getControllerId(aura.getAttachedTo())));
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(aura.getAttachedTo())));
        if (!game.getBattlefield().contains(filter, source.getControllerId(), source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Target)target, source, game);
        return Optional.of(target).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(permanent -> permanent.addAttachment(aura.getId(), source, game)).orElse(false);
    }
}

